/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.shorts;

/**
 * Iterator over a list of short numbers.
 * @see java.util.ListIterator
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface ShortListIterator extends ShortIterator {
    boolean hasNext();
    short next();
    boolean hasPrevious();
    short previous();
    int nextIndex();
    int previousIndex();
    void remove();
    void set(short e);
    void add(short e);
}
